<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "files".
 *
 * @property int $id
 * @property int $bg
 * @property string $created_at
 * @property string $bots
 * @property string $admins
 * @property string $filename
 * @property string $storedfilename
 * @property int $size
 * @property string $filetype
 */
class Files extends \yii\db\ActiveRecord
{
    public $bg;
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'files';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['created_at'], 'safe'],
            [['size'], 'default', 'value' => null],
            [['size', 'admin_id', 'user_id', 'destination', 'current', 'bg', 'actual'], 'integer'],
            [['bots', 'filename', 'storedfilename', 'filetype', 'group', 'version'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'created_at' => 'Uploaded At',
            'bots' => 'Attached Bots',
            'admin_id' => 'Admin',
            'user_id' => 'Admin',
            
            'filename' => 'Real Filename',
            'storedfilename' => 'Stored Filename',
            'size' => 'Size',
            'filetype' => 'Filetype',
            'group' => 'Group',
            'destination' => 'Destination',
            'version' => 'Version',
            'current' => 'Current',
        ];
    }

    public function getActualByStoredfilename($filename){
        $s = static::findOne(['storedfilename' => $filename]);
        if(isset($s)){
            return static::findOne(['storedfilename' => $filename])['actual'];
        }else{
            return null;
        } 
    }

    public function getIDByStoredfilename($filename){
        $s = static::findOne(['storedfilename' => $filename]);
        if(isset($s)){
            return static::findOne(['storedfilename' => $filename])['id'];
        }else{
            return null;
        } 
    }

    public function getFilenameByStoredfilename($filename){
        $s = static::findOne(['storedfilename' => $filename]);
        if(isset($s)){
            return static::findOne(['storedfilename' => $filename])['filename'];
        }else{
            return null;
        } 
    }
}
